(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32838,        953]*)
(*NotebookOutlinePosition[     33681,        980]*)
(*  CellTagsIndexPosition[     33637,        976]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 6.4  .4 \( a\ \  : \ 
            To\ compute\ e_Q\)\  = \ \(intx\  - \ int\n
        \tor\ \ e_Q\  = \ int\  - \ intx\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[s_] := \ x^\((3/4)\)*s^\((5/4)\); \n
    Plot[s^\((5/4)\), \ {s, \ 0, \ \[Pi]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.0147151 0.14073 [
[.17539 .00222 -9 -9 ]
[.17539 .00222 9 0 ]
[.32696 .00222 -3 -9 ]
[.32696 .00222 3 0 ]
[.47854 .00222 -9 -9 ]
[.47854 .00222 9 0 ]
[.63011 .00222 -3 -9 ]
[.63011 .00222 3 0 ]
[.78169 .00222 -9 -9 ]
[.78169 .00222 9 0 ]
[.93327 .00222 -3 -9 ]
[.93327 .00222 3 0 ]
[.01131 .15544 -6 -4.5 ]
[.01131 .15544 0 4.5 ]
[.01131 .29617 -6 -4.5 ]
[.01131 .29617 0 4.5 ]
[.01131 .4369 -6 -4.5 ]
[.01131 .4369 0 4.5 ]
[.01131 .57763 -6 -4.5 ]
[.01131 .57763 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .01472 m
.17539 .02097 L
s
[(0.5)] .17539 .00222 0 1 Mshowa
.32696 .01472 m
.32696 .02097 L
s
[(1)] .32696 .00222 0 1 Mshowa
.47854 .01472 m
.47854 .02097 L
s
[(1.5)] .47854 .00222 0 1 Mshowa
.63011 .01472 m
.63011 .02097 L
s
[(2)] .63011 .00222 0 1 Mshowa
.78169 .01472 m
.78169 .02097 L
s
[(2.5)] .78169 .00222 0 1 Mshowa
.93327 .01472 m
.93327 .02097 L
s
[(3)] .93327 .00222 0 1 Mshowa
.125 Mabswid
.05412 .01472 m
.05412 .01847 L
s
.08444 .01472 m
.08444 .01847 L
s
.11476 .01472 m
.11476 .01847 L
s
.14507 .01472 m
.14507 .01847 L
s
.2057 .01472 m
.2057 .01847 L
s
.23602 .01472 m
.23602 .01847 L
s
.26633 .01472 m
.26633 .01847 L
s
.29665 .01472 m
.29665 .01847 L
s
.35728 .01472 m
.35728 .01847 L
s
.38759 .01472 m
.38759 .01847 L
s
.41791 .01472 m
.41791 .01847 L
s
.44822 .01472 m
.44822 .01847 L
s
.50885 .01472 m
.50885 .01847 L
s
.53917 .01472 m
.53917 .01847 L
s
.56948 .01472 m
.56948 .01847 L
s
.5998 .01472 m
.5998 .01847 L
s
.66043 .01472 m
.66043 .01847 L
s
.69074 .01472 m
.69074 .01847 L
s
.72106 .01472 m
.72106 .01847 L
s
.75138 .01472 m
.75138 .01847 L
s
.81201 .01472 m
.81201 .01847 L
s
.84232 .01472 m
.84232 .01847 L
s
.87264 .01472 m
.87264 .01847 L
s
.90295 .01472 m
.90295 .01847 L
s
.96358 .01472 m
.96358 .01847 L
s
.9939 .01472 m
.9939 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .15544 m
.03006 .15544 L
s
[(1)] .01131 .15544 1 0 Mshowa
.02381 .29617 m
.03006 .29617 L
s
[(2)] .01131 .29617 1 0 Mshowa
.02381 .4369 m
.03006 .4369 L
s
[(3)] .01131 .4369 1 0 Mshowa
.02381 .57763 m
.03006 .57763 L
s
[(4)] .01131 .57763 1 0 Mshowa
.125 Mabswid
.02381 .04286 m
.02756 .04286 L
s
.02381 .07101 m
.02756 .07101 L
s
.02381 .09915 m
.02756 .09915 L
s
.02381 .1273 m
.02756 .1273 L
s
.02381 .18359 m
.02756 .18359 L
s
.02381 .21174 m
.02756 .21174 L
s
.02381 .23988 m
.02756 .23988 L
s
.02381 .26803 m
.02756 .26803 L
s
.02381 .32432 m
.02756 .32432 L
s
.02381 .35247 m
.02756 .35247 L
s
.02381 .38061 m
.02756 .38061 L
s
.02381 .40876 m
.02756 .40876 L
s
.02381 .46505 m
.02756 .46505 L
s
.02381 .4932 m
.02756 .4932 L
s
.02381 .52134 m
.02756 .52134 L
s
.02381 .54949 m
.02756 .54949 L
s
.02381 .60578 m
.02756 .60578 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .02543 L
.10458 .04165 L
.14415 .05906 L
.18221 .07723 L
.22272 .09782 L
.26171 .11866 L
.30316 .14177 L
.34309 .16486 L
.3815 .18777 L
.42237 .21283 L
.46172 .23758 L
.49955 .2619 L
.53984 .28834 L
.57861 .31427 L
.61984 .34235 L
.65954 .36986 L
.69774 .39673 L
.73838 .42574 L
.77751 .45406 L
.81909 .48457 L
.85916 .51434 L
.89771 .54333 L
.93871 .57451 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0003400_l400;o0`03ob00
0olQ00?o1002o`<00olP00Co7`04o`<00_l300?o8@03oaP0000`0004o`00o`<00_l60003o`0001h0
00?o00008@000ol0000300;o1P000ol0000N0003o`00020000?o00000`02o`H000?o00008@000ol0
000E0000<0001?l00?l;0003o`0001h000?o00008@000ol0000;0003o`0001l000?o000080000ol0
000:0003o`00024000?o00005@00030000Co003o2003ob4000?o00008@000ol0000800?o8`000ol0
000P0003o`0000H00olR00;o6000030000Co003o20000ol0000Q0003o`00024000?o000020000ol0
000P0004o`00oal000Co003o20000ol0000T0003o`0001D0000a00;o2@04oal00_lR00;o2P04ob00
0_lQ00;o2@04ob000olH00003`000ol0003o00l0000?0003o`000?l03`0000l000?o0000o`0?0000
3`000ol0003o00l000080?oo4ol600003`000ol00003o`8000?o00001@000ol000050003o`0000H0
00?o00001@000ol000050003o`0000D000?o00001P000ol000050003o`0000D000?o00001P000ol0
00050003o`0000D000?o00001@000ol000060003o`0000D000?o00001@000ol000050003o`0000H0
00?o00001@000ol000050003o`0000D000?o00001P000ol000050003o`0000D000?o00001P000ol0
00050003o`0000D000?o00001@000ol000060003o`0000D000?o00001@000ol0000600003`000ol0
000300?o80000ol0000V0003o`0002L000?o00009P000ol0000V0003o`0002L000?o00005P0000l0
00?o00001P04ool01@0000l000?o00002P03ool00P0000l000?o00003@03ooh0000?0003o`000100
0ook00003`000ol0000C00;on@0000l00_lF00;om`0000l000?o00005`02ooD0000?0003o`0001T0
0_oc00003`000ol0000K00;ol@0000l000?o00007@02onl0000?0003o`0001l00_o]00003`000ol0
000Q00?ojP0000l00_lU00;oj00000l000?o00009P02onH0000?0003o`0002P00_oT00003`000ol0
000Z00;ohP0000l000?o0000;002on00000?0003o`0002h000?o0000g@0000l000?o0000;`02omd0
000?0003o`0003400_oK00003`02oc@00_oI00003`000ol0000e00;oe`0000l000?o0000=`02omD0
000?0003o`0003T00_oC00003`000ol0000k00;od@0000l000?o0000?@02oll0000?0003o`0003l0
0_o=00003`000ol000110003o`000<X0000?00;o@`02olX0000?0003o`0004@00_o800003`000ol0
00160003o`000<D0000?0003o`0004L00_o500003`000ol0001900;o``0000H00ol60003o`0004/0
0_o100001`000ol000050003o`0004d00_no00001`000ol0000500;oD0000ol0002l00001`000ol0
00050003o`0005000_nl00001`000ol000050003o`0005800_nj00001P02o`L000?o0000E002okP0
000?0003o`0005H00_nf00003`000ol0001H0003o`000;<0000?0003o`0005T00_nc00003`000ol0
001K00;o/@0000l00_mN0003o`000:h0000?0003o`0005h00_n^00003`000ol0001P0003o`000:/0
000?0003o`0006400_n[00003`000ol0001S00;oZ@0000l000?o0000I@000ol0002V00003`000ol0
001V00;oYP0000l000?o0000J0000ol0002S00003`02ofX00_nS00003`000ol0001[0003o`000:00
000?0003o`0006`00_nP00003`000ol0001^00;oWP0000l000?o0000L0000ol0002K00003`000ol0
001a00;oV`0000l000?o0000L`000ol0002H00003`02ogD00_nH00003`000ol0001f00;oUP0000l0
00?o0000N0000ol0002C00003`000ol0001i00;oT`0000l000?o0000N`02oi40000?0003o`0007d0
00?o0000SP0000l000?o0000OP02ohh0000?0003o`00080000?o0000R`0000l00_n20003o`0008X0
000?0003o`0008800_n:00003`000ol000240003o`0008L0000?0003o`0008D00_n700003`000ol0
00270003o`0008@0000?0003o`0008P000?o0000P`0000H01?l50003o`0008T00_n300001`000ol0
00050003o`0008/000?o0000P00000P000?o00001002ohd00_n000002@000ol000030003o`0008h0
0_mn00001P001?l00?l50003o`00090000?o0000N`0000L00_l60003o`0009400_mk00003`000ol0
002C0003o`0007P0000?0003o`0009@00_mh00003`000ol0002F0003o`0007D0000?00;oV002ogD0
000?0003o`0009T00_mc00003`000ol0002K0003o`000700000?0003o`0009`00_m`00003`000ol0
002N0003o`0006d0000?0003o`0009l00_m]00003`000ol0002Q0003o`0006X0000?0003o`000:80
00?o0000J@0000l00_nT00;oJ@0000l000?o0000Y@000ol0001V00003`000ol0002V00;oIP0000l0
00?o0000Z0000ol0001S00003`000ol0002Y0003o`000680000?0003o`000:X00_mR00003`000ol0
002/0003o`0005l0000?0003o`000:d00_mO00003`02ok0000?o0000G00000l000?o0000/0000ol0
001K00003`000ol0002a00;oF`0000l000?o0000/`000ol0001H00003`000ol0002d00;oF00000l0
00?o0000]P000ol0001E00003`000ol0002g0003o`0005@0000?00;o^@02oe@0000?0003o`000;X0
00?o0000D@0000l000?o0000^`02oe40000?0003o`000;d000?o0000CP0000l000?o0000_P000ol0
001=00003`000ol0002o00;oC@0000H00ol60003o`000<4000?o0000BP0000T000?o00000`000ol0
00320003o`0004T000090003o`0000<00_o400;oB@0000L00_l60003o`000<D000?o0000AP0000T0
00?o00000`000ol0003600;oAP0000H00ol60003o`000<P000?o0000@`0000l000?o0000b@000ol0
001200003`000ol0003:00;o@P0000l000?o0000c0000ol0000o00003`000ol0003=0003o`0003h0
000?00;oc`02och0000?0003o`000=0000?o0000>`0000l000?o0000d@02oc/0000?0003o`000=<0
00?o0000>00000l000?o0000e0000ol0000g00003`000ol0003E00;o=`0000l000?o0000e`000ol0
000d00003`02omT000?o0000<`0000l000?o0000f@02oc<0000?0003o`000=/000?o0000<00000l0
00?o0000g002oc00000?0003o`000=h000?o0000;@0000l000?o0000g`000ol0000/00003`000ol0
003P00;o;00000l000?o0000hP000ol0000Y00003`02on@000?o0000:00000l000?o0000i002obP0
000?0003o`000>H000?o00009@0000l000?o0000i`02obD0000?0003o`000>T000?o00008P0000l0
00?o0000jP000ol0000Q00003`000ol0003[00;o8@0000l000?o0000k@000ol0000N00003`02onl0
00?o00007@0000l000?o0000k`000ol0000L00003`000ol0003`00;o700000l000?o0000lP000ol0
000I00003`000ol0003c0003o`0001P0000700?o1@000ol0003d0003o`0001L000080003o`0000@0
00?o0000m@000ol0000F00001P04o`D00_og00;o5P0000H000?o0?l01P000ol0003h0003o`0001<0
00060003o`3o00H000?o0000n@02oa<0000700;o1P000ol0003k0003o`000100000?0003o`000?`0
00?o00003`0000l000?o0000o@02o`l0000?0003o`000?l000?o0000300000l000?o0000o`010003
o`0000/0000?00;oo`0@00003`000ol0003o00l0000?0003o`000?l03`0000l000?o0000o`0?0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.182617, -0.323318, 
  0.012096, 0.0260565}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Directly\ by\ Mma\ \ *) \n
    intx = Integrate[g[s], \ {s, \ 0, \[Pi]}] // N\)\)], "Input"],

Cell[BoxData[
    \(5.83989038484010158`\ x\^\(3/4\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ rectangular\ rule\ n = 2\ *) \n
    int = \((\[Pi]/2)\)*\((g[\[Pi]/2] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)\)], "Input"],

Cell[BoxData[
    \(8.2408376543905657`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Rectangular\ rule, \ n = 4\ *) \n
    int = \((\[Pi]/4)\)*
          \((\ g[0.25\ \[Pi]] + g[0.5\ \[Pi]] + g[0.75\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(4.01066785321446772`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 10*) \n
    int = \((\[Pi]/10)\)*
          \((g[0.1\ \[Pi]] + g[0.2\ \[Pi]] + g[0.3\ \[Pi]] + g[0.4\ \[Pi]] + 
              g[0.5\ \[Pi]] + g[0.6\ \[Pi]] + g[0.7\ \[Pi]] + g[0.8\ \[Pi]] + 
              g[0.9\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(1.57408524274764101`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 20*) \n
    int = \((\[Pi]/20)\)*
          \((g[0.05\ \[Pi]] + g[0.1\ \[Pi]] + g[0.15\ \[Pi]] + 
              g[0.2\ \[Pi]] + g[0.25\ \[Pi]] + g[0.3\ \[Pi]] + 
              g[0.35\ \[Pi]] + g[0.4\ \[Pi]] + g[0.45\ \[Pi]] + 
              g[0.5\ \[Pi]] + g[0.55\ \[Pi]] + g[0.6\ \[Pi]] + 
              g[0.65\ \[Pi]] + g[0.7\ \[Pi]] + g[0.75\ \[Pi]] + 
              g[0.8\ \[Pi]] + g[0.85\ \[Pi]] + g[0.9\ \[Pi]] + 
              g[0.95\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.781438781272108418`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 40*) \n
    int = \((\[Pi]/40)\)*
          \((g[0.025\ \[Pi]] + g[0.05\ \[Pi]] + g[0.075\ \[Pi]] + 
              g[0.1\ \[Pi]] + g[0.125\ \[Pi]] + g[0.15\ \[Pi]] + 
              g[0.175\ \[Pi]] + g[0.2\ \[Pi]] + g[0.225\ \[Pi]] + 
              g[0.25\ \[Pi]] + g[0.275\ \[Pi]] + g[0.3\ \[Pi]] + 
              g[0.325\ \[Pi]] + g[0.35\ \[Pi]] + g[0.375\ \[Pi]] + 
              g[0.4\ \[Pi]] + g[0.425\ \[Pi]] + g[0.45\ \[Pi]] + 
              g[0.475\ \[Pi]] + g[0.5\ \[Pi]] + g[0.525\ \[Pi]] + 
              g[0.55\ \[Pi]] + g[0.575\ \[Pi]] + g[0.6\ \[Pi]] + 
              g[0.625\ \[Pi]] + g[0.65\ \[Pi]] + g[0.675\ \[Pi]] + 
              g[0.7\ \[Pi]] + g[0.725\ \[Pi]] + g[0.75\ \[Pi]] + 
              g[0.775\ \[Pi]] + g[0.8\ \[Pi]] + g[0.825\ \[Pi]] + 
              g[0.85\ \[Pi]] + g[0.875\ \[Pi]] + g[0.9\ \[Pi]] + 
              g[0.925\ \[Pi]] + g[0.95\ \[Pi]] + g[0.975\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(0.389220220984803333`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/10)\)*
          \((\ g[0] + 2*g[0.2\ \[Pi]] + 2*g[0.4\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.0886435936129876012`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 10\ *) \n
    int = \((\[Pi]/20)\)*
          \((\ g[0] + 2*g[0.1\ \[Pi]] + 2*g[0.2\ \[Pi]] + 2*g[0.3\ \[Pi]] + 
              2*g[0.4\ \[Pi]] + 2*g[0.5\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.7\ \[Pi]] + 2*g[0.8\ \[Pi]] + 2*g[0.9\ \[Pi]] + g[\[Pi]])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(0.023771408732652528`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 20\ *) \n
    int = \((\[Pi]/40)\)*
          \((\ g[0] + 2*g[0.05\ \[Pi]] + 2*g[0.1\ \[Pi]] + 2*g[0.15\ \[Pi]] + 
              2*g[0.2\ \[Pi]] + 2*g[0.25\ \[Pi]] + 2*g[0.3\ \[Pi]] + 
              2*g[0.35\ \[Pi]] + 2*g[0.4\ \[Pi]] + 2*g[0.45\ \[Pi]] + 
              2*g[0.5\ \[Pi]] + 2*g[0.55\ \[Pi]] + 2*g[0.6\ \[Pi]] + 
              2*g[0.65\ \[Pi]] + 2*g[0.7\ \[Pi]] + 2*g[0.75\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + 2*g[0.85\ \[Pi]] + 2*g[0.9\ \[Pi]] + 
              2*g[0.95\ \[Pi]] + g[\[Pi]])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.00628186426461199864`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 40\ *) \n
    int = \((\[Pi]/80)\)*
          \((\ g[0] + 2*g[0.025\ \[Pi]] + 2*g[0.05\ \[Pi]] + 
              2*g[0.075\ \[Pi]] + \n\t\t\t\ \ \ \ \ \ 2*g[0.1\ \[Pi]] + 
              2*g[0.125\ \[Pi]] + 2*g[0.15\ \[Pi]] + 2*g[0.175\ \[Pi]] + 
              2*g[0.2\ \[Pi]] + 2*g[0.225\ \[Pi]] + 2*g[0.25\ \[Pi]] + 
              2*g[0.275\ \[Pi]] + 2*g[0.3\ \[Pi]] + 2*g[0.325\ \[Pi]] + 
              2*g[0.35\ \[Pi]] + 2*g[0.375\ \[Pi]] + 2*g[0.4\ \[Pi]] + 
              2*g[0.425\ \[Pi]] + 2*g[0.45\ \[Pi]] + 2*g[0.475\ \[Pi]] + 
              2*g[0.5\ \[Pi]] + 2*g[0.525\ \[Pi]] + 2*g[0.55\ \[Pi]] + 
              2*g[0.575\ \[Pi]] + 2*g[0.6\ \[Pi]] + 2*g[0.625\ \[Pi]] + 
              2*g[0.65\ \[Pi]] + 2*g[0.675\ \[Pi]] + 2*g[0.7\ \[Pi]] + 
              2*g[0.725\ \[Pi]] + 2*g[0.75\ \[Pi]] + 2*g[0.775\ \[Pi]] + 
              2*g[0.8\ \[Pi]] + 2*g[0.825\ \[Pi]] + 2*g[0.85\ \[Pi]] + 
              2*g[0.875\ \[Pi]] + 2*g[0.9\ \[Pi]] + 2*g[0.925\ \[Pi]] + 
              2*g[0.95\ \[Pi]] + 2*g[0.975\ \[Pi]] + g[\[Pi]])\) // Simplify; 
    \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.00164176248105519668`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/15)\)*
          \((\ g[0] + 4*g[0.25\ \[Pi]] + 2*g[0.5\ \[Pi]] + 4*g[0.75\ \[Pi]] + 
              g[\[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(2.7427095924553555`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 7\ *) \n
    int = \(\((\[Pi]/21)\)*
            \((\ g[0] + 4*g[\[Pi]/6] + 2*g[\[Pi]/3] + 4*g[\[Pi]/2] + \n
                \t\t\t\t2*g[2\ \[Pi]/3] + 4*g[5\ \[Pi]/6] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(1.96285873952756535`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 9*) \n
    int = \(\((\[Pi]/27)\)*
            \((\ g[0] + 4*g[\[Pi]/8] + 2*g[\[Pi]/4] + 4*g[3\ \[Pi]/8] + \n
                \t\t\t\t2*g[\[Pi]/2] + 4*g[5\ \[Pi]/8] + 2*g[3\ \[Pi]/4] + 
                4*g[7\ \[Pi]/8] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(1.52802341444847478`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 11*) \n
    int = \(\((\[Pi]/33)\)*
            \((\ g[0] + 4*g[\[Pi]/10] + 2*g[\[Pi]/5] + 4*g[3\ \[Pi]/10] + \n
                \t\t\t\t2*g[2\ \[Pi]/5] + 4*g[\[Pi]/2] + 2*g[3\ \[Pi]/5] + 
                4*g[7\ \[Pi]/10] + 2*g[4\ \[Pi]/5] + 4*g[9\ \[Pi]/10] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(1.25082672203707701`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 17*) \n
    int = \(\((\[Pi]/51)\)*
            \((\ g[0] + 4*g[\[Pi]/16] + 2*g[2\ \[Pi]/16] + 4*g[3\ \[Pi]/16] + 
                \n\t\t\t\t2*g[4\ \[Pi]/16] + 4*g[5\ \[Pi]/16] + 
                2*g[6\ \[Pi]/16] + 4*g[7\ \[Pi]/16] + 2*g[8\ \[Pi]/16] + 
                4*g[9\ \[Pi]/16] + 2*g[10\ \[Pi]/16] + 4*g[11\ \[Pi]/16] + 
                2*g[12\ \[Pi]/16] + 4*g[13\ \[Pi]/16] + 2*g[14\ \[Pi]/16] + 
                4*g[15\ \[Pi]/16] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.809918933320871836`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 33*) \n
    int = \(\((\[Pi]/99)\)*
            \((\ g[0] + 4*g[\[Pi]/32] + 2*g[2\ \[Pi]/32] + 4*g[3\ \[Pi]/32] + 
                \n\t\t\t\t2*g[4\ \[Pi]/32] + 4*g[5\ \[Pi]/32] + 
                2*g[6\ \[Pi]/32] + 4*g[7\ \[Pi]/32] + 2*g[8\ \[Pi]/32] + 
                4*g[9\ \[Pi]/32] + 2*g[10\ \[Pi]/32] + 4*g[11\ \[Pi]/32] + 
                2*g[12\ \[Pi]/32] + 4*g[13\ \[Pi]/32] + 2*g[14\ \[Pi]/32] + 
                4*g[15\ \[Pi]/32] + 2*g[16\ \[Pi]/32] + 4*g[17\ \[Pi]/32] + 
                2*g[18\ \[Pi]/32] + 4*g[19\ \[Pi]/32] + 2*g[20\ \[Pi]/32] + 
                4*g[21\ \[Pi]/32] + 2*g[22\ \[Pi]/32] + 4*g[23\ \[Pi]/32] + 
                2*g[24\ \[Pi]/32] + 4*g[25\ \[Pi]/32] + 2*g[26\ \[Pi]/32] + 
                4*g[27\ \[Pi]/32] + 2*g[28\ \[Pi]/32] + 4*g[29\ \[Pi]/32] + 
                4*g[30\ \[Pi]/32] + 4*g[31\ \[Pi]/32] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((int\  - \ intx)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(0.16040054704474171`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 5\ *) \n
    int = \((\[Pi]/5)\)*\ 
          \((g[0.1\ \[Pi]] + g[0.3\ \[Pi]] + g[0.5\ \[Pi]] + g[0.7\ \[Pi]] + 
              g[0.9\ \[Pi]])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.0411007761476867372`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 10\ *) \n
    int = \(\((\[Pi]/10)\)*\ 
            \((g[\[Pi]/20] + g[3\ \[Pi]/20] + g[5\ \[Pi]/20] + 
                g[7\ \[Pi]/20] + g[9\ \[Pi]/20] + g[11\ \[Pi]/20] + 
                g[13\ \[Pi]/20] + g[15\ \[Pi]/20] + g[17\ \[Pi]/20] + 
                g[19\ \[Pi]/20])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.0112076802034285294`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 20\ *) \n
    int = \(\((\[Pi]/20)\)*\ 
            \((g[\[Pi]/40] + g[3\ \[Pi]/40] + g[5\ \[Pi]/40] + 
                g[7\ \[Pi]/40] + g[9\ \[Pi]/40] + g[11\ \[Pi]/40] + 
                g[13\ \[Pi]/40] + g[15\ \[Pi]/40] + g[17\ \[Pi]/40] + 
                g[19\ \[Pi]/40] + g[21\ \[Pi]/40] + g[23\ \[Pi]/40] + 
                g[25\ \[Pi]/40] + g[27\ \[Pi]/40] + g[29\ \[Pi]/40] + 
                g[31\ \[Pi]/40] + g[33\ \[Pi]/40] + g[35\ \[Pi]/40] + 
                g[37\ \[Pi]/40] + g[39\ \[Pi]/40])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.0029983393025016042`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 7\ *) \n
    int = \(\((3\ \[Pi]/70)\)*
            \((g[0] + 5*g[\[Pi]/7] + g[2\ \[Pi]/7] + 6*g[3\ \[Pi]/7] + 
                g[4\ \[Pi]/7] + 5*g[5\ \[Pi]/7] + 2*g[6\ \[Pi]/7] + g[\[Pi]])
              \) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(1.61080703684397636`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \nClear[int, \[CurlyPhi]]; 
    \n (*\ Weddle\ Rule\ n = 13\ *) \n
    int = \(\((3\ \[Pi]/130)\)*
            \((g[0] + 5*g[\[Pi]/13] + g[2\ \[Pi]/13] + 6*g[3\ \[Pi]/13] + 
                g[4\ \[Pi]/13] + 5*g[5\ \[Pi]/13] + 2*g[6\ \[Pi]/13] + 
                5*g[7\ \[Pi]/13] + g[8\ \[Pi]/13] + 6*g[9\ \[Pi]/13] + 
                g[10\ \[Pi]/13] + 5*g[11\ \[Pi]/13] + 2*g[12\ \[Pi]/13] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.907441634118431217`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 19\ *) \n
    int = \(\((3\ \[Pi]/190)\)*
            \((g[0] + 5*g[\[Pi]/19] + g[2\ \[Pi]/19] + 6*g[3\ \[Pi]/19] + 
                g[4\ \[Pi]/19] + 5*g[5\ \[Pi]/19] + 2*g[6\ \[Pi]/19] + 
                5*g[7\ \[Pi]/19] + g[8\ \[Pi]/19] + 6*g[9\ \[Pi]/19] + 
                g[10\ \[Pi]/19] + 5*g[11\ \[Pi]/19] + 2*g[12\ \[Pi]/19] + \n
                \t\t\t\t5*g[13\ \[Pi]/19] + g[14\ \[Pi]/19] + 
                6*g[15\ \[Pi]/19] + g[16\ \[Pi]/19] + 5*g[17  \[Pi]/19] + 
                2*g[18\ \[Pi]/19] + g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.630972980099757307`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 25\ *) \n
    int = \(\((3\ \[Pi]/250)\)*
            \((g[0] + 5*g[\[Pi]/25] + g[2\ \[Pi]/25] + 6*g[3\ \[Pi]/25] + 
                g[4\ \[Pi]/25] + 5*g[5\ \[Pi]/25] + 2*g[6\ \[Pi]/25] + 
                5*g[7\ \[Pi]/25] + g[8\ \[Pi]/25] + 6*g[9\ \[Pi]/25] + 
                g[10\ \[Pi]/25] + 5*g[11\ \[Pi]/25] + 2*g[12\ \[Pi]/25] + \n
                \t\t\t\t5*g[13\ \[Pi]/25] + g[14\ \[Pi]/25] + 
                6*g[15\ \[Pi]/25] + g[16\ \[Pi]/25] + 5*g[17\ \[Pi]/25] + 
                2*g[18\ \[Pi]/25] + \n\t\t\t\t5*g[19\ \[Pi]/25] + 
                g[20\ \[Pi]/25] + 6*g[21\ \[Pi]/25] + g[22\ \[Pi]/25] + 
                5*g[23\ \[Pi]/25] + 2*g[24\ \[Pi]/25] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(0.483524024161135201`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 31\ *) \n
    int = \(\((3\ \[Pi]/310)\)*
            \((g[0] + 5*g[\[Pi]/31] + g[2\ \[Pi]/31] + 6*g[3\ \[Pi]/31] + 
                g[4\ \[Pi]/31] + 5*g[5\ \[Pi]/31] + 2*g[6\ \[Pi]/31] + 
                5*g[7\ \[Pi]/31] + g[8\ \[Pi]/31] + 6*g[9\ \[Pi]/31] + 
                g[10\ \[Pi]/31] + 5*g[11\ \[Pi]/31] + 2*g[12\ \[Pi]/31] + \n
                \t\t\t\t5*g[13\ \[Pi]/31] + g[14\ \[Pi]/31] + 
                6*g[15\ \[Pi]/31] + g[16\ \[Pi]/31] + 5*g[17\ \[Pi]/31] + 
                2*g[18\ \[Pi]/31] + \n\t\t\t\t5*g[19\ \[Pi]/31] + 
                g[20\ \[Pi]/31] + 6*g[21\ \[Pi]/31] + g[22\ \[Pi]/31] + 
                5*g[23\ \[Pi]/31] + 2*g[24\ \[Pi]/31] + 5*g[25\ \[Pi]/31] + 
                g[26\ \[Pi]/31] + 6*g[27\ \[Pi]/31] + g[28\ \[Pi]/31] + 
                5*g[29\ \[Pi]/31] + 2*g[30\ \[Pi]/31] + g[\[Pi]])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(0.391906750938926649`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 37*) \n
    int = \(\((3\ \[Pi]/370)\)*
            \((g[0] + 5*g[\[Pi]/37] + g[2\ \[Pi]/37] + 6*g[3\ \[Pi]/37] + 
                g[4\ \[Pi]/37] + 5*g[5\ \[Pi]/37] + 2*g[6\ \[Pi]/37] + 
                5*g[7\ \[Pi]/37] + g[8\ \[Pi]/37] + 6*g[9\ \[Pi]/37] + 
                g[10\ \[Pi]/37] + 5*g[11\ \[Pi]/37] + 2*g[12\ \[Pi]/37] + \n
                \t\t\t\t5*g[13\ \[Pi]/37] + g[14\ \[Pi]/37] + 
                6*g[15\ \[Pi]/37] + g[16\ \[Pi]/37] + 5*g[17\ \[Pi]/37] + 
                2*g[18\ \[Pi]/37] + \n\t\t\t\t5*g[19\ \[Pi]/37] + 
                g[20\ \[Pi]/37] + 6*g[21\ \[Pi]/37] + g[22\ \[Pi]/37] + 
                5*g[23\ \[Pi]/37] + 2*g[24\ \[Pi]/37] + 5*g[25\ \[Pi]/37] + 
                g[26\ \[Pi]/37] + 6*g[27\ \[Pi]/37] + g[28\ \[Pi]/37] + 
                5*g[29\ \[Pi]/37] + 2*g[30\ \[Pi]/37] + \n\t\t\t\t\t\t\t
                5*g[31\ \[Pi]/37] + g[32\ \[Pi]/37] + 6*g[33\ \[Pi]/37] + 
                g[34\ \[Pi]/37] + 5*g[35\ \[Pi]/37] + 2*g[36\ \[Pi]/37] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.329467745449102622`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 43*) \n
    int = \(\((3\ \[Pi]/430)\)*
            \((g[0] + 5*g[\[Pi]/43] + g[2\ \[Pi]/43] + 6*g[3\ \[Pi]/43] + 
                g[4\ \[Pi]/43] + 5*g[5\ \[Pi]/43] + 2*g[6\ \[Pi]/43] + 
                5*g[7\ \[Pi]/43] + g[8\ \[Pi]/43] + 6*g[9\ \[Pi]/43] + 
                g[10\ \[Pi]/43] + 5*g[11\ \[Pi]/43] + 2*g[12\ \[Pi]/43] + \n
                \t\t\t\t5*g[13\ \[Pi]/43] + g[14\ \[Pi]/43] + 
                6*g[15\ \[Pi]/43] + g[16\ \[Pi]/43] + 5*g[17\ \[Pi]/43] + 
                2*g[18\ \[Pi]/43] + \n\t\t\t\t5*g[19\ \[Pi]/43] + 
                g[20\ \[Pi]/43] + 6*g[21\ \[Pi]/43] + g[22\ \[Pi]/43] + 
                5*g[23\ \[Pi]/43] + 2*g[24\ \[Pi]/43] + 5*g[25\ \[Pi]/43] + 
                g[26\ \[Pi]/43] + 6*g[27\ \[Pi]/43] + g[28\ \[Pi]/43] + 
                5*g[29\ \[Pi]/43] + 2*g[30\ \[Pi]/43] + \n\t\t\t\t\t\t\t
                5*g[31\ \[Pi]/43] + g[32\ \[Pi]/43] + 6*g[33\ \[Pi]/43] + 
                g[34\ \[Pi]/43] + 5*g[35\ \[Pi]/43] + 2*g[36\ \[Pi]/43] + 
                5*g[37\ \[Pi]/43] + g[38\ \[Pi]/43] + 6*g[39\ \[Pi]/43] + 
                g[40\ \[Pi]/43] + 5*g[41\ \[Pi]/43] + 2*g[42\ \[Pi]/43] + 
                g[\[Pi]])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.284185860661364486`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Gauss - Legendre\ rule\ n = 2*) \n
    int = 0.5\ \[Pi]*
          \((g[0.663896644677787772`] + g[2.47769600891200525`])\) // 
        Simplify; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.0368810204205563518`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Gauss - Legendre\ Rule\ n = 4\ *) \n
    int = \ \[Pi]\ *
          \((0.1739274226*g[0.218126571673253266`] + 
              0.3260725774*g[1.03675535235190863`] + 
              0.3260725774*g[2.10483730123788426`] + 
              0.1739274226*g[2.92346608191653967`])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(0.00214868440157754481`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 6\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/6)\)*
          \((g[0.0170370868554658567`]\  + \n\t\t\t\t
              g[0.146446609406726224`] + g[0.370590477448738297`] + 
              g[0.62940952255127458`] + g[0.853553390593233451`] + 
              g[0.982962913144561944`])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(12.7007208085036493`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 8\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/8)\)*
          \((g[0.00960735979838477582`]\  + \n\t\t\t\t
              g[0.0842651938487273355`] + g[0.222214883490200598`] + 
              g[0.402454838991917007`] + g[0.597545161008159819`] + 
              g[0.777785116509540586`] + g[0.915734806151648328`] + 
              g[0.990392640201421059`])\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(12.7006585011041672`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 4\ *) \n
    int = \(\((7*g[0] + 32*g[0.25] + 12*g[0.5] + 32*g[0.75] + 7*g[1])\)/90 // 
          N\) // Simplify; \neQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], 
  "Input"],

Cell[BoxData[
    \(12.7308347659033183`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 5\ *) \n
    int = \(\((
              19*g[0] + 75*g[0.2] + 50*g[0.4] + 50*g[0.6] + 75*g[0.8] + 
                19*g[1])\)/288 // N\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> \[Pi]\)], "Input"],

Cell[BoxData[
    \(12.7311070374766122`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{21, Automatic}, {Automatic, 8}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 174, 3, 43, "Input"],

Cell[CellGroupData[{
Cell[1916, 56, 114, 2, 43, "Input"],
Cell[2033, 60, 10100, 349, 186, 3700, 265, "GraphicsData", "PostScript", \
"Graphics"],
Cell[12136, 411, 130, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12303, 419, 119, 2, 43, "Input"],
Cell[12425, 423, 66, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12528, 429, 191, 3, 59, "Input"],
Cell[12722, 434, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12812, 440, 260, 5, 91, "Input"],
Cell[13075, 447, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13166, 453, 373, 6, 123, "Input"],
Cell[13542, 461, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13633, 467, 603, 10, 155, "Input"],
Cell[14239, 479, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14331, 485, 1064, 17, 235, "Input"],
Cell[15398, 504, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15490, 510, 292, 5, 91, "Input"],
Cell[15785, 517, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15878, 523, 409, 7, 123, "Input"],
Cell[16290, 532, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16382, 538, 648, 10, 187, "Input"],
Cell[17033, 550, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17127, 556, 1173, 17, 299, "Input"],
Cell[18303, 575, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18397, 581, 279, 5, 107, "Input"],
Cell[18679, 588, 53, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18769, 594, 336, 6, 91, "Input"],
Cell[19108, 602, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19199, 608, 378, 6, 123, "Input"],
Cell[19580, 616, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19671, 622, 434, 7, 123, "Input"],
Cell[20108, 631, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20199, 637, 601, 9, 187, "Input"],
Cell[20803, 648, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20895, 654, 1015, 15, 267, "Input"],
Cell[21913, 671, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22004, 677, 280, 5, 107, "Input"],
Cell[22287, 684, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22380, 690, 421, 7, 123, "Input"],
Cell[22804, 699, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22897, 705, 652, 10, 171, "Input"],
Cell[23552, 717, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23645, 723, 345, 6, 107, "Input"],
Cell[23993, 731, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24084, 737, 534, 9, 171, "Input"],
Cell[24621, 748, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24713, 754, 662, 10, 187, "Input"],
Cell[25378, 766, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25470, 772, 831, 13, 219, "Input"],
Cell[26304, 787, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26396, 793, 981, 15, 251, "Input"],
Cell[27380, 810, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27472, 816, 1153, 17, 283, "Input"],
Cell[28628, 835, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28720, 841, 1303, 19, 315, "Input"],
Cell[30026, 862, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30118, 868, 245, 4, 91, "Input"],
Cell[30366, 874, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30459, 880, 387, 7, 139, "Input"],
Cell[30849, 889, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30943, 895, 473, 9, 187, "Input"],
Cell[31419, 906, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31510, 912, 545, 10, 219, "Input"],
Cell[32058, 924, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32149, 930, 243, 4, 107, "Input"],
Cell[32395, 936, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32486, 942, 279, 5, 107, "Input"],
Cell[32768, 949, 54, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

